#include "GWindow.h"
#include "GPreferences.h"
extern GWindow *window;
extern prefs_t prefs;
bool quit;

GWindow::GWindow(void):BWindow(BRect(80,40,300,200),"Folder Cleaner", B_TITLED_WINDOW,B_CURRENT_WORKSPACE|B_NOT_RESIZABLE|B_NOT_ZOOMABLE )
{
	Lock();
	BRoster();
	background =new BView(Bounds(),NULL,B_FOLLOW_ALL_SIDES,B_FRAME_EVENTS|B_WILL_DRAW);
	AddChild(background);
	background->SetViewColor(200,200,200);

	BRect frame(20,10,60,30);
	BStringView *string = new BStringView(frame,"Origin:","Origin:");
	background->AddChild(string);
	frame.OffsetBy(0,20);
	string = new BStringView(frame,"offset","Offset:");
	background->AddChild(string);
	frame.OffsetBy(0,20);
	string = new BStringView(frame,"size","Size:");
	background->AddChild(string);
	
	sprintf(buffer,"%.0f",prefs.rect.left);
	frame.Set(60,10+3,60+60,30+3);
	BTextControl *textcontrol = new BTextControl(frame,"Origin:_x","X:",buffer,NULL,B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	textcontrol->SetDivider(20);
	background->AddChild(textcontrol);
	
	sprintf(buffer,"%.0f",prefs.rect.top);
	frame.OffsetBy(80,0);
	textcontrol = new BTextControl(frame,"Origin:_y","Y:",buffer,NULL,B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	textcontrol->SetDivider(20);
	background->AddChild(textcontrol);
	
	frame.Set(60,10+3+20,60+60,30+3+20);
//	frame.OffsetBy(0,20);
	sprintf(buffer,"%.0f",prefs.offset.x);
	textcontrol = new BTextControl(frame,"offset_x","X:",buffer,NULL,B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	textcontrol->SetDivider(20);
	background->AddChild(textcontrol);
	
	frame.OffsetBy(80,0);
	sprintf(buffer,"%.0f",prefs.offset.y);
	textcontrol = new BTextControl(frame,"offset_y","Y:",buffer,NULL,B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	textcontrol->SetDivider(20);
	background->AddChild(textcontrol);
	frame.Set(60,10+3+40,60+60,30+3+40);
//	frame.OffsetBy(0,40);
	sprintf(buffer,"%.0f",prefs.rect.right-prefs.rect.left);
	textcontrol = new BTextControl(frame,"size_x","X:",buffer,NULL,B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	textcontrol->SetDivider(20);
	background->AddChild(textcontrol);
	
	frame.OffsetBy(80,0);
	sprintf(buffer,"%.0f",prefs.rect.bottom-prefs.rect.top);
	textcontrol = new BTextControl(frame,"size_y","Y:",buffer,NULL,B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	textcontrol->SetDivider(20);
	background->AddChild(textcontrol);
	
	frame.Set(20,100,20+50,100+20);
	BButton *button = new BButton(frame,"about","About..",new BMessage(B_ABOUT_REQUESTED),B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	button->SetTarget(be_app);
	background->AddChild(button);
	
	frame.OffsetBy(50+10,0);
	button = new BButton(frame,"quit","Quit",new BMessage(B_QUIT_REQUESTED),B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	button->SetTarget(be_app);
	background->AddChild(button);
	
//	frame.OffsetBy(50+10,0);
//	button = new BButton(frame,"default","Default",new BMessage(G_DEFAULT_REQUESTED),B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
//	background->AddChild(button);
	
	frame.OffsetBy(50+10,0);
	button = new BButton(frame,"Go","Go",new BMessage(G_GO_REQUESTED),B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	button->MakeDefault(true);
	background->AddChild(button);
//	frame.Set(20,120,Bounds().right-20,120+20);
//	string = new BStringView(frame,NULL,NULL);
//	background->AddChild(string);
	Unlock();
	Show();
}

bool GWindow::QuitRequested(void)
{
	Stop();
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}

void GWindow::Stop(void)
{
	quit = true;
	thread_info info;
	status_t stat;
	if( get_thread_info( id, &info) == B_NO_ERROR )
	{
		wait_for_thread(id, &stat);
	}
}

void GWindow::MessageReceived(BMessage *message)
{
	Lock();
	switch(message->what)
	{
	case G_GO_REQUESTED:
		BTextControl *textcontrol;
		textcontrol = (BTextControl *)FindView("Origin:_x");
		prefs.rect.left =atof(textcontrol->Text());
		
		textcontrol = (BTextControl *)FindView("Origin:_y");
		prefs.rect.top =atof(textcontrol->Text());
		
		textcontrol = (BTextControl *)FindView("offset_x");
		prefs.offset.x =atof(textcontrol->Text());
		
		textcontrol = (BTextControl *)FindView("offset_y");
		prefs.offset.y =atof(textcontrol->Text());
		
		textcontrol = (BTextControl *)FindView("size_x");
		prefs.rect.right =atof(textcontrol->Text())+prefs.rect.left;
		textcontrol = (BTextControl *)FindView("size_y");
		prefs.rect.bottom =atof(textcontrol->Text())+prefs.rect.top;
		id = spawn_thread(Stack,"Stack",B_NORMAL_PRIORITY,NULL);
		resume_thread(id);
		break;
	default:
		inherited::MessageReceived(message);
		break;
	}
	Unlock();
}

long Stack(void *a1)
{
	BEntry entry("/boot/");
	window->Lock();
	BButton *button = (BButton *)window->FindView("Go");
	button->SetEnabled(false);
	button->Invalidate();
	window->Unlock();
	Recurse(&entry);
	window->Lock();
	button->SetEnabled(true);
	button->Invalidate();
	window->Unlock();
}

void Recurse(BEntry *entry)
{
BDirectory dir(entry);
BPath path;
BEntry entry2;
if(dir.InitCheck() == B_NO_ERROR)
	{
	path.SetTo(&dir,NULL,false);
	printf("Processing: %s\n",(char *)path.Path());
	int depth=0;
	char *copy = (char *)path.Path();
	while((copy =strchr(copy,'/')) != NULL)
	{
		depth++;
		copy +=1;
	}
	BRect rect(prefs.rect);
	rect.OffsetBy(prefs.offset.x*depth,prefs.offset.y*depth);
	if(strcmp("/boot/home/Desktop",path.Path()))
		dir.WriteAttr("_trk/windframe",B_RECT_TYPE,0,&rect,sizeof(BRect));
	while((dir.GetNextEntry(&entry2,false)!= B_ENTRY_NOT_FOUND) &&  !quit)
			if(!entry2.IsSymLink())
				Recurse(&entry2);
	}
}
//
//inline int Depth(char *path)
//{
//	int depth=0;
//	char *copy = path;
//	while((copy =strchr(copy,'/')) != NULL)
//	{
//		depth++;
//		copy +=1;
//	}
//	return(depth);
//}
